-- Update slugs to SEO format (industry-localite-nom) without BCE in URL
-- Generated: 2026-02-16T11:46:01.890Z

BEGIN;

CREATE TEMP TABLE tmp_slug_map (
  old_slug text PRIMARY KEY,
  new_slug text NOT NULL,
  bce_number text NULL,
  industry_category text NULL
) ON COMMIT DROP;

INSERT INTO tmp_slug_map (old_slug, new_slug, bce_number, industry_category) VALUES
  ('dm-synergie-0443623461', 'plombier-a-oupeye-dm-synergie', 'BE0443623461', 'Plombier'),
  ('vrancken-0864832303', 'chauffagiste-a-liege-vrancken', 'BE0864832303', 'Chauffagiste'),
  ('coelmont-climatisation-et-pompe-a-chaleur-0822561087', 'climatisation-a-awans-coelmont-climatisation-et-pompe-a-chaleur', 'BE0822561087', 'Climatisation'),
  ('arthopia-0893142049', 'climatisation-a-sprimont-arthopia', 'BE0893142049', 'Climatisation'),
  ('serrurerie-liege-a-la-forge-0434520804', 'serrurier-a-liege-serrurerie-liege-a-la-forge', 'BE0434520804', 'Serrurier'),
  ('secutek-liege-0803679444', 'serrurier-a-liege-secutek-liege', 'BE0803679444', 'Serrurier'),
  ('serrurier-vincent-0845546921', 'serrurier-a-liege-serrurier-vincent', 'BE0845546921', 'Serrurier'),
  ('serrurier-bertrand-a-lieges-et-namur-1012947541', 'serrurier-a-lie-serrurier-bertrand-a-lieges-et-namur', 'BE1012947541', 'Serrurier'),
  ('toiture-delhez-liege-0536793941', 'toiture-a-trooz-toiture-delhez-liege', 'BE0536793941', 'Toiture'),
  ('ramackers-toitures-0403915621', 'toiture-a-liege-ramackers-toitures', 'BE0403915621', 'Toiture'),
  ('ville-de-liege-0540801625', 'facadier-a-liege-ville-de-liege', 'BE0540801625', 'Façadier'),
  ('bronkart-sa-0457686283', 'facadier-a-liege-bronkart-sa', 'BE0457686283', 'Façadier'),
  ('chassis-liege-0729787616', 'chassis-a-liege-chassis-liege', 'BE0729787616', 'Châssis'),
  ('vitrerie-couard-0462315064', 'vitrier-a-verviers-vitrerie-couard', 'BE0462315064', 'Vitrier'),
  ('contact-0822692731', 'menuisier-a-liege-menuiserie-momin', 'BE0822692731', 'Menuisier'),
  ('menuiserie-collignon-0404403886', 'menuisier-a-ans-menuiserie-collignon', 'BE0404403886', 'Menuisier'),
  ('ruggieri-jose-carrelage-0800880597', 'carreleur-a-seraing-ruggieri-jose-carrelage', 'BE0800880597', 'Carreleur'),
  ('vanden-borre-kitchen-grivegnee-0637991566', 'cuisiniste-a-grivegnee-vanden-borre-kitchen-grivegnee', 'BE0637991566', 'Cuisiniste'),
  ('contact-0417853531', 'cuisiniste-a-beaufays-cuisine-conseil', 'BE0417853531', 'Cuisiniste'),
  ('lhonneux-renovation-0806318141', 'entreprise-de-renovation-a-olne-lhonneux-renovation', 'BE0806318141', 'Entreprise de rénovation'),
  ('step-reno-0798252194', 'entreprise-de-renovation-a-liege-step-reno', 'BE0798252194', 'Entreprise de rénovation'),
  ('atom-construction-0774711482', 'entreprise-de-renovation-a-liege-atom-construction', 'BE0774711482', 'Entreprise de rénovation'),
  ('cm-construction-0767583863', 'macon-a-liege-cm-construction', 'BE0767583863', 'Maçon'),
  ('s-gillon-0469460204', 'terrassement-a-grivegnee-s-gillon', 'BE0469460204', 'Terrassement'),
  ('lucas-david-sprl-0878415865', 'terrassement-a-liege-lucas-david-sprl', 'BE0878415865', 'Terrassement'),
  ('jme-construct-0874697696', 'amenagement-exterieur-a-lontzen-jme-construct', 'BE0874697696', 'Aménagement extérieur'),
  ('mossay-bertrand-0785721576', 'amenagement-exterieur-a-melen-mossay-bertrand', 'BE0785721576', 'Aménagement extérieur'),
  ('nrj-0737457940', 'panneaux-solaires-a-chaudfontaine-nrj', 'BE0737457940', 'Panneaux solaires'),
  ('mentions-legales-0839879250', 'audit-energetique-a-argenteau-mentions-legales', 'BE0839879250', 'Audit énergétique'),
  ('certinergie-entreprises-et-secteur-public-0536501654', 'audit-energetique-a-verlaine-certinergie-entreprises-et-secteur-public', 'BE0536501654', 'Audit énergétique'),
  ('mb-protect-1003332861', 'installateur-securite-a-glons-mb-protect', 'BE1003332861', 'Installateur sécurité'),
  ('federation-asd-0462309126', 'aide-a-domicile-a-grace-hollogne-federation-asd', 'BE0462309126', 'Aide à domicile'),
  ('dog-beauty-0725437759', 'toiletteur-canin-a-saint-nicolas-dog-beauty', 'BE0725437759', 'toiletteur canin'),
  ('popochon-0638971068', 'toiletteur-canin-a-liege-popochon', 'BE0638971068', 'toiletteur canin'),
  ('votre-photographe-en-region-liegeoise-0639958983', 'photographe-a-donceel-votre-photographe-en-region-liegeoise', 'BE0639958983', 'Photographe'),
  ('julien-stevens-photography-0741395645', 'photographe-a-liege-julien-stevens-photography', 'BE0741395645', 'Photographe'),
  ('traiteur-les-cours-herve-battice-liege-0479904728', 'traiteur-a-herve-battice-traiteur-les-cours-herve-battice-liege', 'BE0479904728', 'Traiteur'),
  ('contact-0421661176', 'traiteur-a-liege-traiteur-simonis-and-letal-dor', 'BE0421661176', 'Traiteur'),
  ('marie-pirretz-0860388218', 'coach-sportif-a-liege-marie-pirretz', 'BE0860388218', 'Coach sportif'),
  ('politique-de-confidentialite-0870417424', 'agence-web-a-liege-politique-de-confidentialite', 'BE0870417424', 'Agence web'),
  ('idagency-0693816353', 'agence-web-a-herstal-idagency', 'BE0693816353', 'Agence web'),
  ('contactez-nous-0806850651', 'agence-web-a-lontzen-agence-digitale-defaweux', 'BE0806850651', 'Agence web'),
  ('eteamsys-0812368367', 'seo-a-liege-eteamsys', 'BE0812368367', 'SEO'),
  ('lessa-proposgreater-de-novaia-0537363964', 'seo-a-theux-lessa-proposgreater-de-novaia', 'BE0537363964', 'SEO'),
  ('localisy-web-agency-liege-0578866306', 'seo-a-liege-localisy-web-agency-liege', 'BE0578866306', 'SEO'),
  ('studio-lemplume-graphiste-et-designer-de-marque-0792466244', 'graphiste-a-hermee-studio-lemplume-graphiste-et-designer-de-marque', 'BE0792466244', 'Graphiste'),
  ('shinka-it-0838560941', 'support-it-a-beaufays-shinka-it', 'BE0838560941', 'Support IT'),
  ('spark-sa-0445492294', 'electricien-a-charleroi-spark-sa', 'BE0445492294', 'Électricien'),
  ('dg-elec-1002150550', 'electricien-a-haulchin-dg-elec', 'BE1002150550', 'Électricien'),
  ('grossiste-en-chauffage-climatisation-and-ventilation-0457736367', 'climatisation-a-charleroi-grossiste-en-chauffage-climatisation-and-ventilation', 'BE0457736367', 'Climatisation'),
  ('new-miranda-0832069265', 'serrurier-a-charleroi-new-miranda', 'BE0832069265', 'Serrurier'),
  ('charleroi-serrures-portes-blindees-coffres-fort-0435178721', 'serrurier-a-charleroi-nord-charleroi-serrures-portes-blindees-coffres-fort', 'BE0435178721', 'Serrurier'),
  ('delta-depannage-serrurier-charleroi-24h7-0688917754', 'serrurier-a-charleroi-delta-depannage-serrurier-charleroi-24h7', 'BE0688917754', 'Serrurier'),
  ('jcl-toitures-charleroi-0462385637', 'toiture-a-montignies-le-tilleul-jcl-toitures-charleroi', 'BE0462385637', 'Toiture'),
  ('cs-toiture-0784614093', 'toiture-a-jumet-cs-toiture', 'BE0784614093', 'Toiture'),
  ('greg-toiture-0758692032', 'toiture-a-charleroi-greg-toiture', 'BE0758692032', 'Toiture'),
  ('ets-ekelmans-0440464528', 'facadier-a-charleroi-ets-ekelmans', 'BE0440464528', 'Façadier'),
  ('crepi-et-ravalement-de-facade-0677630716', 'facadier-a-aiseau-presles-crepi-et-ravalement-de-facade', 'BE0677630716', 'Façadier'),
  ('gaume-0454357995', 'chassis-a-montignies-sur-sambre-gaume', 'BE0454357995', 'Châssis'),
  ('menuisier-a-jumet-charleroi-mordant-andamp-fils-menuiserie-interieure-exterieure-0438101389', 'chassis-a-jumet-menuisier-a-jumet-charleroi-mordant-andamp-fils-menuiserie-interieure-exterieure', 'BE0438101389', 'Châssis'),
  ('pasquarelli-0829800158', 'chassis-a-montigny-le-tilleul-pasquarelli', 'BE0829800158', 'Châssis'),
  ('vitrerie-vincent-glass-0883282790', 'vitrier-a-charleroi-vitrerie-vincent-glass', 'BE0883282790', 'Vitrier'),
  ('noooon-0548908944', 'menuisier-a-courcelles-noooon', 'BE0548908944', 'Menuisier'),
  ('as-plafonnages-0877853067', 'plafonneur-a-wanfercee-baulet-as-plafonnages', 'BE0877853067', 'Plafonneur'),
  ('julien-peinture-0685517212', 'peintre-a-courcelles-julien-peinture', 'BE0685517212', 'Peintre'),
  ('adecor-sprl-0440845895', 'cuisiniste-a-fleurus-adecor-sprl', 'BE0440845895', 'Cuisiniste'),
  ('design-partner-0509980072', 'cuisiniste-a-gozee-design-partner', 'BE0509980072', 'Cuisiniste'),
  ('oht-cuisine-and-electro-0445781316', 'cuisiniste-a-charleroi-oht-cuisine-and-electro', 'BE0445781316', 'Cuisiniste'),
  ('youkitchen-0644847090', 'cuisiniste-a-nalinnes-youkitchen', 'BE0644847090', 'Cuisiniste'),
  ('inside-renovation-0781921651', 'entreprise-de-renovation-a-marcinelle-inside-renovation', 'BE0781921651', 'Entreprise de rénovation'),
  ('terracap-0843586531', 'terrassement-a-fleurus-terracap', 'BE0843586531', 'Terrassement'),
  ('vdrt-van-damme-0550964750', 'terrassement-a-frasnes-lez-gosselies-vdrt-van-damme', 'BE0550964750', 'Terrassement'),
  ('bathosol-0696806428', 'terrassement-a-jumet-bathosol', 'BE0696806428', 'Terrassement'),
  ('garden-sylva-0452777390', 'amenagement-exterieur-a-ransart-garden-sylva', 'BE0452777390', 'Aménagement extérieur'),
  ('jardinerie-tournesols-0477173484', 'jardinage-a-charleroi-jardinerie-tournesols', 'BE0477173484', 'Jardinage'),
  ('jardinerie-animalerie-et-pepiniere-a-gozee-et-jumet-0420901707', 'jardinage-a-gozee-gozee-jardinerie-animalerie-et-pepiniere-a-gozee-et-jumet', 'BE0420901707', 'Jardinage'),
  ('clean-works-srl-1016643934', 'nettoyage-a-jumet-clean-works-srl', 'BE1016643934', 'Nettoyage'),
  ('wordpress-website-0777531709', 'panneaux-solaires-a-jumet-wordpress-website', 'BE0777531709', 'Panneaux solaires'),
  ('alarme-de-clerck-0461785029', 'installateur-securite-a-forchies-la-marche-alarme-de-clerck', 'BE0461785029', 'Installateur sécurité'),
  ('global-care-nurse-at-home-0750830577', 'aide-a-domicile-a-anderlues-global-care-nurse-at-home', 'BE0750830577', 'Aide à domicile'),
  ('specialiste-photo-a-charleroi-pour-sauver-votre-histoire-0424707966', 'photographe-a-charleroi-specialiste-photo-a-charleroi-pour-sauver-votre-histoire', 'BE0424707966', 'Photographe'),
  ('le-comptoir-by-au-trou-normand-1004963352', 'traiteur-a-charleroi-le-comptoir-by-au-trou-normand', 'BE1004963352', 'Traiteur'),
  ('jeveuxunsitebe-0658736304', 'agence-web-a-fontaine-leveque-jeveuxunsitebe', 'BE0658736304', 'Agence web'),
  ('clef2web-agence-de-marketing-digital-0874833102', 'agence-web-a-gosselies-adresse-siege-social-de-mons-clef2web-agence-de-marketing-digital', 'BE0874833102', 'Agence web'),
  ('indigo-studio-0759692419', 'agence-web-a-montigny-le-tilleul-indigo-studio', 'BE0759692419', 'Agence web'),
  ('chevalier-company-0527965159', 'agence-web-a-montigny-le-tilleul-chevalier-company', 'BE0527965159', 'Agence web'),
  ('colors-of-life-0810824780', 'graphiste-a-ransart-colors-of-life', 'BE0810824780', 'Graphiste'),
  ('nearmi-0775370191', 'developpeur-a-charleroi-nearmi', 'BE0775370191', 'Développeur'),
  ('developpeur-web-a-charleroi-0472101473', 'developpeur-a-marcinelle-developpeur-web-a-charleroi', 'BE0472101473', 'Développeur'),
  ('uniwan-0869754557', 'support-it-a-fleurus-uniwan', 'BE0869754557', 'Support IT'),
  ('ets-laurent-christian-0421365723', 'plombier-a-namur-ets-laurent-christian', 'BE0421365723', 'Plombier'),
  ('mentions-legales-0765620802', 'plombier-a-vezin-mentions-legales', 'BE0765620802', 'Plombier'),
  ('alex-0736825856', 'electricien-a-cognelee-alex', 'BE0736825856', 'Électricien'),
  ('de-electricite-electricite-generale-0633766920', 'electricien-a-namur-de-electricite-electricite-generale', 'BE0633766920', 'Électricien'),
  ('noooon-0647596447', 'chauffagiste-a-erpent-noooon', 'BE0647596447', 'Chauffagiste'),
  ('srl-marchal-0401407378', 'climatisation-a-namur-srl-marchal', 'BE0401407378', 'Climatisation'),
  ('philippe-lange-0719662301', 'toiture-a-namur-philippe-lange', 'BE0719662301', 'Toiture'),
  ('isolution-0827451669', 'isolation-a-namur-isolution', 'BE0827451669', 'Isolation'),
  ('scid-0441236073', 'chassis-a-sorinnes-scid', 'BE0441236073', 'Châssis'),
  ('christophe-dosimont-peinture-0690480741', 'peintre-a-lesve-christophe-dosimont-peinture', 'BE0690480741', 'Peintre'),
  ('contact-0442395422', 'peintre-a-sambreville-gsm-moret-and-fils', 'BE0442395422', 'Peintre'),
  ('jean-francois-feraille-specialiste-en-pose-de-carrelage-and-de-douches-italiennes-0460246687', 'carreleur-a-emines-jean-francois-feraille-specialiste-en-pose-de-carrelage-and-de-douches-italie', 'BE0460246687', 'Carreleur'),
  ('contactez-nous-0548642391', 'entreprise-de-renovation-a-namur-ai-renov', 'BE0548642391', 'Entreprise de rénovation'),
  ('nkconstructionbe-1021823140', 'macon-a-namur-nkconstructionbe', 'BE1021823140', 'Maçon'),
  ('crimi-fortunato-0670597820', 'macon-a-eghezee-plan-d-crimi-fortunato', 'BE0670597820', 'Maçon'),
  ('entreprise-de-terrassement-etdamenagements-exterieurs-0821281875', 'terrassement-a-couvin-entreprise-de-terrassement-etdamenagements-exterieurs', 'BE0821281875', 'Terrassement'),
  ('frateur-piscines-and-jardins-0402559502', 'terrassement-a-namur-frateur-piscines-and-jardins', 'BE0402559502', 'Terrassement'),
  ('societe-de-nettoyage-pour-bureaux-entreprises-et-particuliers-0859969534', 'nettoyage-a-bouge-societe-de-nettoyage-pour-bureaux-entreprises-et-particuliers', 'BE0859969534', 'Nettoyage'),
  ('contactez-verminex-1003237049', 'deratisation-a-malonne-e-mail-verminex', 'BE1003237049', 'Dératisation'),
  ('respect-de-la-vie-privee-traitement-des-donnees-personnelles-0629689059', 'ramonage-a-anhee-respect-de-la-vie-privee-traitement-des-donnees-personnelles', 'BE0629689059', 'Ramonage'),
  ('contact-le-hublot-formation-0421446291', 'reparation-electromenager-a-saint-servais-le-hublot-centre-de-formation-professionnelle-nouveau', 'BE0421446291', 'Réparation électroménager'),
  ('jm-photovoltaique-srl-0763616959', 'panneaux-solaires-a-baillonville-jm-photovoltaique-srl', 'BE0763616959', 'Panneaux solaires'),
  ('batigrade-0785377524', 'audit-energetique-a-fernelmont-batigrade', 'BE0785377524', 'Audit énergétique'),
  ('mentions-legales-enhestiaclick-to-open-the-search-input-fieldscroll-to-top-0785949329', 'audit-energetique-a-isnes-mentions-legales-enhestiaclick-to-open-the-search-input-fieldscroll-to', 'BE0785949329', 'Audit énergétique'),
  ('demenagement-breuse-0666872030', 'demenageur-a-andenne-demenagement-breuse', 'BE0666872030', 'Déménageur'),
  ('avsecurity-0567520373', 'installateur-securite-a-jambes-avsecurity', 'BE0567520373', 'Installateur sécurité'),
  ('photo-piron-0862293673', 'photographe-a-namur-photo-piron', 'BE0862293673', 'Photographe'),
  ('au-ptit-gourmand-0666468885', 'traiteur-a-namur-au-ptit-gourmand', 'BE0666468885', 'Traiteur'),
  ('maison-saint-aubain-0741854911', 'traiteur-a-namur-maison-saint-aubain', 'BE0741854911', 'Traiteur'),
  ('vdp-traiteur-0654767519', 'traiteur-a-malonne-vdp-traiteur', 'BE0654767519', 'Traiteur'),
  ('trouvetonrestobe-0671895640', 'traiteur-a-wepion-trouvetonrestobe', 'BE0671895640', 'Traiteur'),
  ('contact-0418689414', 'traiteur-a-naninne-difalux', 'BE0418689414', 'Traiteur'),
  ('mentions-legales-0803972919', 'coach-sportif-a-gesves-mentions-legales', 'BE0803972919', 'Coach sportif'),
  ('mentions-legales-0809115206', 'agence-web-a-cineysupportpour-une-assistance-immediate-mentions-legales', 'BE0809115206', 'Agence web'),
  ('gintlemen-0751906584', 'agence-web-a-namur-gintlemen', 'BE0751906584', 'Agence web'),
  ('fidelo-agency-0660739056', 'agence-web-a-isnes-fidelo-agency', 'BE0660739056', 'Agence web'),
  ('creatonit-0716801888', 'graphiste-a-profondeville-creatonit', 'BE0716801888', 'Graphiste'),
  ('interface3namur-0870417226', 'developpeur-a-namur-interface3namur', 'BE0870417226', 'Développeur'),
  ('marcometbe-1003310491', 'gestion-reseaux-sociaux-a-loyers-marcometbe', 'BE1003310491', 'Gestion Réseaux sociaux'),
  ('akxio-it-0666788292', 'support-it-a-namur-akxio-it', 'BE0666788292', 'Support IT'),
  ('plombier-actif-dans-la-region-de-mons-0889599965', 'plombier-a-grand-reng-plombier-actif-dans-la-region-de-mons', 'BE0889599965', 'Plombier'),
  ('ac-solutions-1004668491', 'climatisation-a-la-louviere-emplacement-du-bureau-ac-solutions', 'BE1004668491', 'Climatisation'),
  ('noooon-0840917744', 'climatisation-a-mons-noooon', 'BE0840917744', 'Climatisation'),
  ('atelier-pierlot-0888641051', 'serrurier-a-tournai-atelier-pierlot', 'BE0888641051', 'Serrurier'),
  ('serrurerie-agore-0442626440', 'serrurier-a-hyon-serrurerie-agore', 'BE0442626440', 'Serrurier'),
  ('ad-toiture-fils-1001714941', 'toiture-a-ghlin-ad-toiture-fils', 'BE1001714941', 'Toiture'),
  ('isoterme-0659966818', 'isolation-a-boussoit-isoterme', 'BE0659966818', 'Isolation'),
  ('mentions-legales-0896092334', 'plafonneur-a-mons-mentions-legales', 'BE0896092334', 'Plafonneur'),
  ('omnicolore-0780705983', 'peintre-a-mons-omnicolore', 'BE0780705983', 'Peintre'),
  ('artisan-carreleur-de-pere-en-fils-0478613440', 'carreleur-a-saint-ghislain-artisan-carreleur-de-pere-en-fils', 'BE0478613440', 'Carreleur'),
  ('votre-entrepreneur-en-renovation-a-mons-0834721325', 'entreprise-de-renovation-a-quevy-le-petit-votre-entrepreneur-en-renovation-a-mons', 'BE0834721325', 'Entreprise de rénovation'),
  ('brubati-0830008016', 'macon-a-flenu-brubati', 'BE0830008016', 'Maçon'),
  ('terrassementfrancoisnicolasbe-0686702095', 'terrassement-a-obourg-legal-be-terrassementfrancoisnicolasbe', 'BE0686702095', 'Terrassement'),
  ('parent-srl-votre-expert-enamenagement-exterieur-0897864365', 'amenagement-exterieur-a-dour-parent-srl-votre-expert-enamenagement-exterieur', 'BE0897864365', 'Aménagement extérieur'),
  ('bati-jardin-0553462105', 'amenagement-exterieur-a-casteau-bati-jardin', 'BE0553462105', 'Aménagement extérieur'),
  ('mairesse-olivier-jardin-0667469272', 'jardinage-a-spiennes-mairesse-olivier-jardin', 'BE0667469272', 'Jardinage'),
  ('entreprise-feuille-et-bois-0784741084', 'jardinage-a-mons-entreprise-feuille-et-bois', 'BE0784741084', 'Jardinage'),
  ('contact-0674674194', 'nettoyage-a-tournai-froyennes-valor-services-group', 'BE0674674194', 'Nettoyage'),
  ('servicegardebe-0207656808', 'deratisation-a-mons-servicegardebe', 'BE0207656808', 'Dératisation'),
  ('votre-expert-en-ramonage-tubage-de-cheminee-et-reparation-de-toiture-0883930811', 'ramonage-a-boussu-votre-expert-en-ramonage-tubage-de-cheminee-et-reparation-de-toiture', 'BE0883930811', 'Ramonage'),
  ('offre-promo-0757972153', 'audit-energetique-a-colfontaine-offre-promo', 'BE0757972153', 'Audit énergétique'),
  ('infocge-servicescom-0867666879', 'installateur-securite-a-mons-infocge-servicescom', 'BE0867666879', 'Installateur sécurité'),
  ('ccda-alarmez-vous-0478615321', 'installateur-securite-a-nimy-ccda-alarmez-vous', 'BE0478615321', 'Installateur sécurité'),
  ('lt-elec-0676409308', 'installateur-securite-a-baudour-lt-elec', 'BE0676409308', 'Installateur sécurité'),
  ('aramis-0692881292', 'coach-sportif-a-mons-aramis', 'BE0692881292', 'Coach sportif'),
  ('a-propos-de-moi-0667654958', 'coach-sportif-a-strepy-bracquegnies-a-propos-de-moi', 'BE0667654958', 'Coach sportif'),
  ('webstanz-0739656573', 'agence-web-a-mons-belgium-webstanz', 'BE0739656573', 'Agence web'),
  ('mentions-legales-0538820152', 'agence-web-a-mons-mentions-legales', 'BE0538820152', 'Agence web'),
  ('renaud-de-harlez-creation-de-sites-web-0840519054', 'seo-a-braine-le-comte-renaud-de-harlez-creation-de-sites-web', 'BE0840519054', 'SEO'),
  ('group-graphic-0811288501', 'graphiste-a-mons-group-graphic', 'BE0811288501', 'Graphiste'),
  ('mission-target-0718839482', 'developpeur-a-mons-contactez-noussuivez-nous-sur-mission-target', 'BE0718839482', 'Développeur'),
  ('sip-0744713639', 'support-it-a-tournai-sip', 'BE0744713639', 'Support IT'),
  ('a-antoine-new-0449402978', 'plombier-a-chapelle-lez-a-antoine-new', 'BE0449402978', 'Plombier'),
  ('db-domotique-0660772413', 'electricien-a-la-louviere-db-domotique', 'BE0660772413', 'Électricien'),
  ('serrurerie-inghels-1028847227', 'serrurier-a-managee-mail-serrurerie-inghels', 'BE1028847227', 'Serrurier'),
  ('lock-security-0563327104', 'serrurier-a-la-louviere-lock-security', 'BE0563327104', 'Serrurier'),
  ('votre-expert-en-toiture-a-la-louviere-0768267615', 'toiture-a-la-louviere-votre-expert-en-toiture-a-la-louviere', 'BE0768267615', 'Toiture'),
  ('zephir-construction-0788847550', 'facadier-a-la-louviere-zephir-construction', 'BE0788847550', 'Façadier'),
  ('menuiserie-dinau-0846096455', 'chassis-a-la-louviere-menuiserie-dinau', 'BE0846096455', 'Châssis'),
  ('a-la-recherche-dun-poseur-de-chassis-dans-la-province-du-hainaut-0443977512', 'chassis-a-binchen-a-la-recherche-dun-poseur-de-chassis-dans-la-province-du-hainaut', 'BE0443977512', 'Châssis'),
  ('renovation-lenoir-sprl-0474710080', 'menuisier-a-herquegies-renovation-lenoir-sprl', 'BE0474710080', 'Menuisier'),
  ('pinzini-decor-0773727329', 'peintre-a-la-louviere-n-pinzini-decor', 'BE0773727329', 'Peintre'),
  ('neptuno-0437420213', 'carreleur-a-strepy-bracquegnies-neptuno', 'BE0437420213', 'Carreleur'),
  ('new-cuisibat-0477071833', 'cuisiniste-a-houdeng-goegnies-new-cuisibat', 'BE0477071833', 'Cuisiniste'),
  ('entreprise-de-terrassement-and-damenagements-exterieurs-a-morlanwelz-et-dans-sa-region-0558974673', 'terrassement-a-la-louviere-entreprise-de-terrassement-and-damenagements-exterieurs-a-morlanwelz', 'BE0558974673', 'Terrassement'),
  ('beton-premium-0864477955', 'terrassement-a-la-louviere-beton-premium', 'BE0864477955', 'Terrassement'),
  ('tbatservices-0698848475', 'amenagement-exterieur-a-la-louviere-tbatservices', 'BE0698848475', 'Aménagement extérieur'),
  ('bryan-ghislain-jardin-0712874576', 'amenagement-exterieur-a-manage-page-facebook-bryan-ghislain-jardin', 'BE0712874576', 'Aménagement extérieur'),
  ('energie-logement-0804985677', 'audit-energetique-a-morlanwelz-gsm-energie-logement', 'BE0804985677', 'Audit énergétique'),
  ('sud-radio-belgique-0423917912', 'audit-energetique-a-mons-sud-radio-belgique', 'BE0423917912', 'Audit énergétique'),
  ('installateur-de-systemes-dalarme-en-belgique-0433033437', 'installateur-securite-a-la-louviere-installateur-de-systemes-dalarme-en-belgique', 'BE0433033437', 'Installateur sécurité'),
  ('cobatec-0840029502', 'installateur-securite-a-la-louviere-cobatec', 'BE0840029502', 'Installateur sécurité'),
  ('egf-sprl-0461769785', 'installateur-securite-a-strepy-bracquegnies-egf-sprl', 'BE0461769785', 'Installateur sécurité'),
  ('la-louviere-0871429489', 'aide-a-domicile-a-la-louviere-itineraire-acces-la-louviere', 'BE0871429489', 'Aide à domicile'),
  ('contactez-votre-coach-sportif-personnel-a-la-louviere-0869870462', 'coach-sportif-a-la-louviere-piron-nicolas', 'BE0869870462', 'Coach sportif'),
  ('zixar-agence-web-1032903114', 'agence-web-a-carnieres-zixar-agence-web', 'BE1032903114', 'Agence web'),
  ('chewing-com-1027982442', 'agence-web-a-la-louviere-chewing-com', 'BE1027982442', 'Agence web'),
  ('dbbase-0471895496', 'support-it-a-la-louviere-dbbase', 'BE0471895496', 'Support IT'),
  ('depannage-plombier-pres-de-tournai-0694681336', 'plombier-a-herseaux-geoffreyovlaque-depannage-plombier-pres-de-tournai', 'BE0694681336', 'Plombier'),
  ('votre-electricien-a-tournai-24-heures-sur-24-dans-toute-la-region-du-tournaisis-0820390564', 'electricien-a-tournai-votre-electricien-a-tournai-24-heures-sur-24-dans-toute-la-region-du-tourn', 'BE0820390564', 'Électricien'),
  ('dupont-toiture-0780552664', 'toiture-a-tournai-dupont-toiture', 'BE0780552664', 'Toiture'),
  ('specialiste-du-rejointoyage-et-sablage-a-tournai-0767613755', 'facadier-a-vaulx-specialiste-du-rejointoyage-et-sablage-a-tournai', 'BE0767613755', 'Façadier'),
  ('tournaibe-0207354920', 'facadier-a-tournai-tournaibe', 'BE0207354920', 'Façadier'),
  ('meunier-freres-0543606410', 'isolation-a-hollain-meunier-freres', 'BE0543606410', 'Isolation'),
  ('ideal-volet-0479378057', 'chassis-a-lun-ven-ideal-volet', 'BE0479378057', 'Châssis'),
  ('contact-0449128509', 'menuisier-a-tournai-dapsens-soyer', 'BE0449128509', 'Menuisier'),
  ('dupriez-sa-0477209514', 'peintre-a-kain-dupriez-sa', 'BE0477209514', 'Peintre'),
  ('dervaux-ebenisterie-0769578006', 'cuisiniste-a-beclers-dervaux-ebenisterie', 'BE0769578006', 'Cuisiniste'),
  ('monument-hainaut-0402515257', 'entreprise-de-renovation-a-marquain-t-monument-hainaut', 'BE0402515257', 'Entreprise de rénovation'),
  ('lgd-piscines-and-terrassement-0766299406', 'terrassement-a-celles-lgd-piscines-and-terrassement', 'BE0766299406', 'Terrassement'),
  ('terrassement-callens-0721866080', 'terrassement-a-celles-terrassement-callens', 'BE0721866080', 'Terrassement'),
  ('asphaltage-antoing-0836509885', 'terrassement-a-antoing-asphaltage-antoing', 'BE0836509885', 'Terrassement'),
  ('architectes-paysagistesdepuis-de-30-ans-0473360097', 'amenagement-exterieur-a-saint-maur-architectes-paysagistesdepuis-de-30-ans', 'BE0473360097', 'Aménagement extérieur'),
  ('dct-0691746590', 'amenagement-exterieur-a-rumes-dct', 'BE0691746590', 'Aménagement extérieur'),
  ('architecte-paysagiste-0860466511', 'amenagement-exterieur-a-frasnes-lez-anvaing-pjbroucke-architecte-paysagiste', 'BE0860466511', 'Aménagement extérieur'),
  ('vercaigne-michael-0670369473', 'jardinage-a-tournai-vercaigne-michael', 'BE0670369473', 'Jardinage'),
  ('benjamin-delhaye-architecte-paysagiste-tournai-hainaut-0502412587', 'jardinage-a-vaulx-leau-la-terre-la-pierre-le-bois-benjamin-delhaye-architecte-paysagiste-tournai', 'BE0502412587', 'Jardinage'),
  ('antinuisible-srl-0751525910', 'deratisation-a-tournai-antinuisible-srl', 'BE0751525910', 'Dératisation'),
  ('strn-societe-de-ramonage-gainage-renovation-nettoyage-generale-0822512785', 'ramonage-a-leuze-en-hainaut-strn-societe-de-ramonage-gainage-renovation-nettoyage-generale', 'BE0822512785', 'Ramonage'),
  ('votre-installateur-de-panneaux-solaires-dans-la-region-de-tournai-0447106256', 'panneaux-solaires-a-marquain-votre-installateur-de-panneaux-solaires-dans-la-region-de-tournai', 'BE0447106256', 'Panneaux solaires'),
  ('solarvolt-1000406431', 'panneaux-solaires-a-tournai-siege-social-solarvolt', 'BE1000406431', 'Panneaux solaires'),
  ('fandampf-elec-0804789204', 'borne-de-recharge-a-templeuve-fandampf-elec', 'BE0804789204', 'Borne de recharge'),
  ('borne4all-srl-photovoltaique-borne-de-recharge-0776663360', 'borne-de-recharge-a-beloeil-borne4all-srl-photovoltaique-borne-de-recharge', 'BE0776663360', 'Borne de recharge'),
  ('cereco-1000697629', 'audit-energetique-a-tournai-cereco', 'BE1000697629', 'Audit énergétique'),
  ('technical-security-systems-srl-0501687760', 'installateur-securite-a-bassily-technical-security-systems-srl', 'BE0501687760', 'Installateur sécurité'),
  ('photographe-patricia-h-0472445626', 'photographe-a-estaimpuis-photographe-patricia-h', 'BE0472445626', 'Photographe'),
  ('antalys-agence-web-de-developpement-de-sites-internet-0473464423', 'agence-web-a-tournai-antalys-agence-web-de-developpement-de-sites-internet', 'BE0473464423', 'Agence web'),
  ('abc-site-web-0840953673', 'agence-web-a-pipaix-abc-site-web', 'BE0840953673', 'Agence web'),
  ('tiptop-studio-1004144889', 'graphiste-a-kain-tiptop-studio', 'BE1004144889', 'Graphiste'),
  ('com-un-declic-0863133318', 'gestion-reseaux-sociaux-a-mouscron-com-un-declic', 'BE0863133318', 'Gestion Réseaux sociaux'),
  ('sip-0476172208', 'support-it-a-tournai-sip-2', 'BE0476172208', 'Support IT'),
  ('comfort-gilson-0825382007', 'chauffagiste-a-seraing-comfort-gilson', 'BE0825382007', 'Chauffagiste');

-- Phase 1: park old slugs to avoid unique collisions during rename.
UPDATE companies c
SET slug = '__tmp__' || md5(c.slug)
FROM tmp_slug_map m
WHERE c.slug = m.old_slug
  AND m.old_slug <> m.new_slug
  AND (m.bce_number IS NULL OR c.bce_number = m.bce_number);

-- Phase 2: apply final slug + canonical industry + canonical revelys URL in JSON-LD.
UPDATE companies c
SET
  slug = m.new_slug,
  industry = COALESCE(m.industry_category, c.industry),
  seo_jsonld = CASE
    WHEN c.seo_jsonld IS NULL THEN c.seo_jsonld
    WHEN jsonb_typeof(c.seo_jsonld) <> 'object' THEN c.seo_jsonld
    ELSE jsonb_set(c.seo_jsonld, '{url}', to_jsonb(('https://revelys.be/entreprises/' || m.new_slug)::text), true)
  END
FROM tmp_slug_map m
WHERE c.slug = '__tmp__' || md5(m.old_slug)
  AND m.old_slug <> m.new_slug
  AND (m.bce_number IS NULL OR c.bce_number = m.bce_number);

COMMIT;

-- Note: image URLs are intentionally left unchanged (storage paths still point to existing uploaded files).
